using System;
using System.Data;
using System.Reflection;
using RACKTEST = gov.va.med.vbecs.Common.VbecsTables.RackTest;

namespace gov.va.med.vbecs.BOL
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary></summary>

		#endregion

	public class RackTest : BaseBusinessObject
	{
		private int _reagentAmount;
		private string _rackTestResultTypeCode;
		private string _rackTestResult;
		private System.DateTime _testDate;
		private System.Guid _rackTestGUID;
		//private System.Data.DataTable _dtRackTests;
		/// <summary>
		/// Rack test table field names
		/// </summary>
		public const string RACKTESTCOLUMNS = "RackTestGuid,TestDate,RackTestResult,RackTestResultTypeCode,ReagentAmount";

	
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1306"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Valid rack test object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3690"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Empty constructor
		/// </summary>
		public RackTest()
 		{
 		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2417"> 
		///		<ExpectedInput>DataRow containing RackTest data</ExpectedInput>
		///		<ExpectedOutput>RackTest object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2869"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates RackTest object and populates it with data from DataRow
		/// </summary>
		/// <param name="dr"></param>
		public RackTest(DataRow dr)
		{
			this.LoadFromDataRow(dr);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1307"> 
		///		<ExpectedInput>GUID</ExpectedInput>
		///		<ExpectedOutput>GUID</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3691"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Rack Test GUID
		/// </summary>
		public System.Guid RackTestGuid
		{
			get
			{
				return this._rackTestGUID;
			}
			set
			{
				this._rackTestGUID = value;
			}
		}



		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1312"> 
		///		<ExpectedInput> date</ExpectedInput>
		///		<ExpectedOutput>date</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3692"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Date of test
		/// </summary>
		public DateTime TestDate
		{
			get
			{
				return this._testDate;
			}
			set
			{
				this._testDate = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1313"> 
		///		<ExpectedInput>Valid string</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3693"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Rack Test Result
		/// </summary>
		public string RackTestResult
		{
			get
			{
				return this._rackTestResult;
			}
			set
			{
				this._rackTestResult = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1314"> 
		///		<ExpectedInput>Valid string</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3694"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Rack Test Result Type Code
		/// </summary>
		public string RackTestResultTypeCode
		{
			get
			{
				return this._rackTestResultTypeCode;
			}
			set
			{
				this._rackTestResultTypeCode = value;
			}
		}


		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1316"> 
		///		<ExpectedInput>Valid int</ExpectedInput>
		///		<ExpectedOutput>Valid int</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3695"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Reagent Amount
		/// </summary>
		public int ReagentAmount
		{
			get
			{
				return this._reagentAmount;
			}
			set
			{
				this._reagentAmount = value;
			}
		}
	
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1322"> 
		///		<ExpectedInput>reagent GUID and rack GUID</ExpectedInput>
		///		<ExpectedOutput>Datatable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1990"> 
		///		<ExpectedInput>invalid guids</ExpectedInput>
		///		<ExpectedOutput>Empty data table</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns a Rack Test Result
		/// </summary>
		/// <param name="reagentGuid"></param>
		/// <param name="RackGuid"></param>
		/// <param name="dailyQcWorklistGuid"></param>
		/// <returns></returns>
		public static DataTable GetRackTestResult(Guid reagentGuid, Guid RackGuid, Guid dailyQcWorklistGuid)
		{
			return DAL.RackTest.GetRackTestResult(reagentGuid, RackGuid, dailyQcWorklistGuid);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/29/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1547"> 
		///		<ExpectedInput>reagent GUID, rack GUID and type of the result</ExpectedInput>
		///		<ExpectedOutput>String</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1996"> 
		///		<ExpectedInput>Invalid invalid reagent GUID, invalid rack GUID</ExpectedInput>
		///		<ExpectedOutput>Empty string</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns the result for previous testing
		/// </summary>
		/// <param name="reagentGuid"></param>
		/// <param name="RackGuid"></param>
		/// <param name="testWithId"></param>
		/// <param name="testWithName"></param>
		/// <param name="rackTestResultTypeCode"></param>
		/// <param name="testDateTime"></param>
		/// <returns></returns>
		public static string GetPreviousRackTestResult(Guid reagentGuid, Guid RackGuid, int testWithId, string testWithName, string rackTestResultTypeCode, DateTime testDateTime)
		{
			DataTable dt = DAL.RackTest.GetPreviousRackTestResult(reagentGuid, RackGuid, testWithId, testWithName, rackTestResultTypeCode, testDateTime);
			if (dt.Rows.Count > 0)
			{
				return dt.Rows[0][RACKTEST.RackTestResult].ToString().Trim();
			}
			else
				return string.Empty;
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1549"> 
		///		<ExpectedInput>rackguid, datatables, updatefunction</ExpectedInput>
		///		<ExpectedOutput>True</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1997"> 
		///		<ExpectedInput>Invalid rackguid</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Inactivates test results for the rack
		/// </summary>
		/// <param name="dailyQcWorklistGuid"></param>
		/// <param name="dtQcInactivated"></param>
		/// <param name="dtQcInactivatedReagents"></param>
		/// <param name="lastUpdateFunctionId">UC or calling method</param>
		/// <returns></returns>
		public static bool InactivateRackTestResults(Guid dailyQcWorklistGuid, DataTable dtQcInactivated, DataTable dtQcInactivatedReagents, Common.UpdateFunction lastUpdateFunctionId)
		{
			if (dailyQcWorklistGuid != Guid.Empty)
			{ 
				// Three tables: RackTest, RackLot, DailyQcWorklist
				DataSet rackData = DAL.RackTest.GetRackInfoByDailyQcWorklistGuid( dailyQcWorklistGuid );
				//
				DataTable dtRackTest = rackData.Tables[0].Copy();
				dtRackTest.Columns.Add(Common.VbecsTables.RackTest.LastUpdateFunctionId, typeof(int));
				dtRackTest = Common.Utility.AppendLastUpdateInformation( dtRackTest, lastUpdateFunctionId );
				//
				DataTable dtRackLot = rackData.Tables[1].Copy();
				dtRackLot.Columns.Add(Common.VbecsTables.RackLot.LastUpdateFunctionId, typeof(int));
				dtRackLot = Common.Utility.AppendLastUpdateInformation( dtRackLot, lastUpdateFunctionId );
				//
				DataTable dtDailyQcWorklist = rackData.Tables[2].Copy();
				dtDailyQcWorklist.Columns.Add(Common.VbecsTables.DailyQcWorklist.LastUpdateFunctionId, typeof(int));
				dtDailyQcWorklist = Common.Utility.AppendLastUpdateInformation( dtDailyQcWorklist, lastUpdateFunctionId );
				//
				return DAL.RackTest.InactivateRackTestResults(dtRackLot, dtRackTest, dtDailyQcWorklist, dtQcInactivated, dtQcInactivatedReagents);
			}
			else
			{
				return true;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3696"> 
		///		<ExpectedInput>division, reagentguid</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3697"> 
		///		<ExpectedInput>invalid division, reagentguid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Get the latest test results for the reagent
		/// </summary>
		/// <param name="divisionCode"></param>
		/// <param name="reagentGuid"></param>
		/// <returns></returns>
		public static DataTable GetReagentTestResult(string divisionCode, Guid reagentGuid)
		{
			return DAL.RackTest.GetReagentTestResult(divisionCode, reagentGuid);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3698"> 
		///		<ExpectedInput>division, reagentguid, date</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3699"> 
		///		<ExpectedInput>invalid division, reagentguid, date</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Get the latest test results for the reagent on a given date
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="reagentGuid">Reagent GUID</param>
		/// <param name="testDate">Specific date to look for test results</param>
		/// <returns></returns>
		public static DataTable GetReagentTestResult(string divisionCode, Guid reagentGuid, DateTime testDate)
		{
			return DAL.RackTest.GetReagentTestResult(divisionCode, reagentGuid, testDate.Date);
		}

		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3700"> 
		///		<ExpectedInput>division, reagentguid, date, phase</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3701"> 
		///		<ExpectedInput>invalid division, reagentguid, date, phase</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Get the latest test results for the reagent on a given date using specific test phases
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <param name="reagentGuid">Reagent GUID</param>
		/// <param name="testDate">Specific date to look for test results</param>
		/// <param name="testingPhaseCode">Specific reactivity phase cose to serach for</param>
		/// <returns>DataTable containing the latest test results for a given reagent on a given date performed using given testing phases</returns>
		public static DataTable GetReagentTestResult(string divisionCode, Guid reagentGuid, DateTime testDate, char testingPhaseCode)
		{
			return DAL.RackTest.GetReagentTestResult(divisionCode, reagentGuid, testDate.Date, testingPhaseCode);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Loads an object from a data row
		/// </summary>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			if(this.VerifyMinColumnsInDataTable(RACKTESTCOLUMNS.Split(','), dtRow.Table))
			{
				this.RackTestGuid = dtRow.IsNull(RACKTEST.RackTestGuid) ? Guid.Empty : (System.Guid) dtRow[RACKTEST.RackTestGuid];
				this.TestDate = dtRow.IsNull(RACKTEST.TestDate) ? DateTime.MinValue : (System.DateTime) dtRow[RACKTEST.TestDate];
				this.RackTestResult = dtRow.IsNull(RACKTEST.RackTestResult) ? string.Empty : dtRow[RACKTEST.RackTestResult].ToString();
				this.RackTestResultTypeCode = dtRow.IsNull(RACKTEST.RackTestResultTypeCode) ? string.Empty : dtRow[RACKTEST.RackTestResultTypeCode].ToString();
				this.ReagentAmount = dtRow.IsNull(RACKTEST.ReagentAmount) ? 0 : (int) dtRow[RACKTEST.ReagentAmount];
				this.IsNew = false;
			}
			else
			{
				throw new BusinessObjectException(Common.StrRes.SysErrMsg.Common.GeneralError(
					Common.Utility.ParseStringwithSpaces(MethodBase.GetCurrentMethod().Name)).ResString);	
			}
		}



		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1325"> 
		///		<ExpectedInput>Valid data row</ExpectedInput>
		///		<ExpectedOutput>Valid data row</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="2867"> 
		///		<ExpectedInput>Invalid DataRow</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			if(this.VerifyMinColumnsInDataTable(RACKTESTCOLUMNS.Split(','), dtRow.Table))
			{
				dtRow[RACKTEST.RackTestGuid] = this.RackTestGuid;
				dtRow[RACKTEST.TestDate] = this.TestDate;
				dtRow[RACKTEST.RackTestResult] = this.RackTestResult;
				dtRow[RACKTEST.RackTestResultTypeCode] = this.RackTestResultTypeCode;
				dtRow[RACKTEST.ReagentAmount] = this.ReagentAmount;
				return dtRow;
			}
			else
			{
				throw new BusinessObjectException(Common.StrRes.SysErrMsg.Common.GeneralError(
					Common.Utility.ParseStringwithSpaces(MethodBase.GetCurrentMethod().Name)).ResString);	
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1326"> 
		///		<ExpectedInput>string array of column names, Valid data table</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2862"> 
		///		<ExpectedInput>string array of column names, empty data table</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Checks the columns in the data table against a string array of column names
		/// </summary>
		public bool VerifyMinColumnsInDataTable(string [] colNames, System.Data.DataTable dtTable)
		{
			return Common.Utility.VerifyMinColumnsInDataTable(RACKTESTCOLUMNS.Split(','), dtTable);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4317"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4318"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Get empty table schema for use when inserting/updating rack tests into the database
		/// </summary>
		/// <param name="insert">Insert Indicator. True if inserting, false if updating</param>
		/// <returns>Rack Test table schema</returns>
		public static DataTable GetRackTestTableSchema(bool insert)
		{
			DataTable dt = new DataTable(RACKTEST.TableName);
			if (insert)
			{
				dt.Columns.Add(RACKTEST.RackLotGuid, typeof(Guid));
				dt.Columns.Add(RACKTEST.RackTestResultTypeCode, typeof(string));
			}
			else
			{
				dt.Columns.Add(RACKTEST.RowVersion, typeof(byte[]));
			}
			dt.Columns.Add(RACKTEST.TestDate,typeof(DateTime));
			dt.Columns.Add(RACKTEST.RackTestGuid, typeof(Guid));
			dt.Columns.Add(RACKTEST.RackTestResult,typeof(string));
			dt.Columns.Add(RACKTEST.TestTechId,typeof(string));
			dt.Columns.Add(RACKTEST.RecordStatusCode, typeof(char));
			dt.Columns.Add(RACKTEST.DivisionCode, typeof(string));
			//dt.Columns.Add(RACKTEST.LastUpdateUser, typeof(string));
			return dt;
		}


	}
}


